import React, { FC } from 'react';

import { IconButton, Icons, IconsProps } from '@storybook/components';

export interface ToolbarMenuButtonProps {
  icon?: IconsProps['icon'];
  description?: string;
  onClick?: () => void;
}

export const ToolbarButton: FC<ToolbarMenuButtonProps> = (props) => {
  const { icon, description, children, onClick } = props;

  return (
    <IconButton title={description} onClick={onClick}>
      {icon && <Icons icon={icon} />}
      {children && (
        <>
          &nbsp;
          {children}
        </>
      )}
    </IconButton>
  );
};
