const path = require('path');
const postcss = require('postcss');

module.exports = {
  stories: ['../src/**/*.@(stories|examples).@(ts|tsx)'],
  addons: [
    './addons/toolbar/preset',
    '@storybook/addon-essentials',
    {
      name: '@storybook/addon-postcss',
      options: {
        postcssLoaderOptions: {
          postcssOptions: {
            config: path.resolve(__dirname, '../.config/postcss/storybook/postcss.config.js'),
          },
          implementation: postcss,
        },
      },
    },
    './addons/css-modules/preset',
  ],
  typescript: {
    check: false,
    reactDocgen: false,
  },
  webpackFinal: (config) => {
    config.resolve.alias['@yandex-id/components'] = path.resolve(__dirname, '../src');

    return config;
  },
};
