import React from 'react';

import { Story } from '@storybook/react';

import { AddressCard, AddressCardProps } from '../AddressCard';
import { AddressType } from '../constants';

type DefaultArgs = AddressCardProps;

export const Default: Story<DefaultArgs> = (props) => (
  <AddressCard {...props} data-testid="element" />
);

Default.args = {
  addressType: AddressType.Home,
  info: {
    locality: 'Москва',
    street: 'ул. Льва Толстого',
    building: 16,
    room: 4,
    entrance: 1,
    floor: 1,
  },
  locationImageUrl:
    'https://static-maps.yandex.ru/1.x/?l=map&ll=37.677751,55.757718&spn=0.01,0.01&l=map&size=124,172',
};

Default.argTypes = {
  addressType: {
    control: { type: 'select' },
    options: Object.values(AddressType),
    defaultValue: AddressType.Other,
  },
  locationImageUrl: {
    control: 'text',
    required: false,
  },
  href: {
    control: 'text',
    required: false,
  },
};
