import React from 'react';

import { Story } from '@storybook/react';

import { AddressCard, AddressCardProps } from '../AddressCard';
import { AddressType } from '../constants';

type DefaultArgs = AddressCardProps;

export const NewAddress: Story<DefaultArgs> = (props) => (
  <AddressCard {...props} data-testid="element" />
);

NewAddress.args = {
  addressType: AddressType.Home,
};

NewAddress.argTypes = {
  addressType: {
    control: { type: 'select' },
    options: Object.values(AddressType),
  },
  href: {
    control: 'text',
    required: false,
  },
};
