import React from 'react';

import {
  AddHomeIcon,
  AddOtherIcon,
  AddWorkIcon,
  HomeIcon,
  OtherIcon,
  WorkIcon,
} from '@yandex-id/icons';

export const MAX_LINES_NUMBER = 3;

export enum AddressType {
  Home = 'Дом',
  Work = 'Работа',
  Other = 'Другой адрес',
}

export const AddressDescriptrion = {
  [AddressType.Home]: 'Добавить домашний адрес',
  [AddressType.Work]: 'Добавить рабочий адрес',
  [AddressType.Other]: 'Добавить ещё один адрес',
};

export const AddressIcon = {
  [AddressType.Home]: <HomeIcon />,
  [AddressType.Work]: <WorkIcon />,
  [AddressType.Other]: <OtherIcon />,
};

export const AddressAddIcon = {
  [AddressType.Home]: <AddHomeIcon />,
  [AddressType.Work]: <AddWorkIcon />,
  [AddressType.Other]: <AddOtherIcon />,
};
