import { BankCardProps } from '../BankCard@types';
import { BankCardType } from '../constants';

export function useBankCardRest(props: BankCardProps) {
  let restProps;

  if (props.bankCardType === BankCardType.Default) {
    const { bank, paymentSystem, cardNumber, label, money, bankCardType: type, ...rest } = props;

    restProps = rest;
  } else if (props.bankCardType === BankCardType.FamilyMember) {
    const { isLoading, money, userPicProps, bankCardType: type, ...rest } = props;

    restProps = rest;
  }

  return {
    restProps,
  };
}
