import { BankCardSizes } from '../BankCard@types';
import {
  BankColors,
  BankIconSize,
  CardBank,
  CardSystem,
  getCardBankIcon,
  getCardSystemIcon,
} from '../constants';

export function useBankCardState(
  cardBank?: CardBank,
  bankCardSize?: BankCardSizes,
  cardSystem?: CardSystem,
) {
  if (!cardBank) {
    return {
      bankIcon: null,
      paymentIcon: null,
      backgroundColor: undefined,
      textColor: undefined,
    };
  }

  const bankIcon = getCardBankIcon(
    cardBank,
    bankCardSize === 's' ? BankIconSize.S : BankIconSize.L,
  );
  const paymentIcon = cardSystem ? getCardSystemIcon(cardSystem, bankCardSize) : null;
  const bankColors = BankColors[cardBank] || BankColors[CardBank.Unknown];

  if (process.env.NODE_ENV !== 'production') {
    if (!bankColors) {
      throw new Error('Error in useBankCardState, incorrect cardBank.');
    }
  }

  return {
    bankIcon,
    paymentIcon,
    ...bankColors,
  };
}
