import { IClassNameProps } from '@bem-react/core';
import { PressProps } from '@use-platform/react';
import { IUserPicProps } from '@yandex-lego/components/UserPic';

import { BankCardType, CardBank, CardSystem } from './constants';

export type BankCardSizes = 's' | 'l';

/*   BankCardBaseProps   */
export interface BankCardDefaultBaseProps extends IClassNameProps, PressProps {
  cardNumber: string;
  label?: string;
  money?: string;

  bank?: CardBank;
  paymentSystem: CardSystem;
}

export interface BankCardFamilyMemberBaseProps extends IClassNameProps, PressProps {
  money: string;
  isLoading?: boolean;
  userPicProps?: IUserPicProps;
}

/*   BankCardProps props   */
export interface BankCardDefaultProps extends BankCardDefaultBaseProps {
  bankCardType: BankCardType.Default;
  size?: BankCardSizes;
}

export interface BankCardFamilyMemberProps extends BankCardFamilyMemberBaseProps {
  bankCardType: BankCardType.FamilyMember;
  label?: string;
  size?: BankCardSizes;
}

export type BankCardProps = BankCardDefaultProps | BankCardFamilyMemberProps;

export interface BankCardPreviewDefaultBaseProps {
  bank?: CardBank;
}

export interface BankCardPreviewDefaultProps
  extends BankCardPreviewDefaultBaseProps,
    IClassNameProps {
  bankCardType: BankCardType.Default;
}

export interface BankCardPreviewFamilyMemberProps extends IClassNameProps {
  bankCardType: BankCardType.FamilyMember;
}

export type BankCardPreviewProps = BankCardPreviewDefaultProps | BankCardPreviewFamilyMemberProps;
