import classnames from 'classnames';
import React, { FC } from 'react';

import { HeartDefaultIcon } from '@yandex-id/icons';

import { useBankCardState } from './BankCard.hooks/useBankCardState';
import { BankCardPreviewProps } from './BankCard@types';
import { BankCardType } from './constants';

import styles from './BankCardPreview.module.css';

export const BankCardPreview: FC<BankCardPreviewProps> = ({ className, ...props }) => {
  const { bankCardType, ...rest } = props;

  const { bankIcon, backgroundColor } = useBankCardState(
    props.bankCardType !== BankCardType.FamilyMember ? props.bank : undefined,
    's',
  );

  if (props.bankCardType === BankCardType.FamilyMember) {
    return (
      <div className={classnames(styles.container, styles.family, className)} {...rest}>
        <HeartDefaultIcon className={classnames(styles.familyIcon)} type="heart" />
      </div>
    );
  }

  return (
    <div
      className={classnames(styles.container, className)}
      {...rest}
      style={{ backgroundColor: backgroundColor }}
    >
      {bankIcon}
    </div>
  );
};
