import classnames from 'classnames';
import React from 'react';

import { Text } from '@yandex-int/tap-components/Skeleton';
import { UserPic } from '@yandex-lego/components/UserPic';

import styles from './BankCardSkeleton.module.css';

export const BankCardSkeleton: React.FC = () => {
  return (
    <div className={classnames(styles.container)}>
      <UserPic
        className={classnames(styles.icon)}
        lodpiUrl={require('../BankCard.assets/avatar.svg')}
      />
      <div className={classnames(styles.description)}>
        <span className={classnames(styles.subInfo)}>Семейная карта</span>
        <Text className={classnames(styles.info)} width={80} size={18} />
      </div>
    </div>
  );
};
