import React from 'react';

import { Story } from '@storybook/react';

import { BankCard } from '../BankCard';
import { BankCardDefaultProps } from '../BankCard@types';
import { BankCardType, CardBank, CardSystem } from '../constants';

type DefaultArgs = Omit<BankCardDefaultProps, 'bankCardType'>;

export const Default: Story<DefaultArgs> = (args) => (
  <BankCard bankCardType={BankCardType.Default} {...args} data-testid="element" />
);

Default.args = {
  cardNumber: '•• 4100',
  bank: CardBank.BelinvestBank,
  paymentSystem: CardSystem.JCB,
};

Default.argTypes = {
  bank: {
    control: { type: 'select' },
    options: Object.values(CardBank),
  },
  paymentSystem: {
    control: { type: 'select' },
    options: Object.values(CardSystem),
  },
  size: {
    control: { type: 'select' },
    options: ['s', 'l'],
  },
  cardNumber: {
    control: 'text',
    required: true,
  },
  label: {
    control: 'text',
    required: false,
  },
  money: {
    control: 'text',
    required: false,
  },
};
