import React, { useEffect, useState } from 'react';

import { Story } from '@storybook/react';

import { BankCard } from '../BankCard';
import { BankCardFamilyMemberProps } from '../BankCard@types';
import { BankCardType } from '../constants';

type FamilylArgs = Omit<BankCardFamilyMemberProps, 'bankCardType' | 'isLoading'>;

export const FamilyMember: Story<FamilylArgs> = (args) => {
  const [isLoading, setIsLoading] = useState(true);

  useEffect(() => {
    setTimeout(() => {
      setIsLoading(false);
    }, 1000);
  }, []);

  return (
    <BankCard
      bankCardType={BankCardType.FamilyMember}
      {...args}
      isLoading={isLoading}
      data-testid="element"
      label="Семейная карта"
    />
  );
};

FamilyMember.args = {
  money: '5000 ₽ на неделю',
};

FamilyMember.argTypes = {
  money: {
    control: 'text',
    required: false,
  },
  size: {
    control: { type: 'select' },
    options: ['s', 'l'],
  },
};
