import React from 'react';

import { Story } from '@storybook/react';

import { BankCard } from '../BankCard';
import { BankCardDefaultProps } from '../BankCard@types';
import { BankCardType, CardBank, CardSystem } from '../constants';

type FamilylArgs = Omit<BankCardDefaultProps, 'bankCardType'>;

export const FamilyOwner: Story<FamilylArgs> = (args) => (
  <BankCard bankCardType={BankCardType.Default} {...args} data-testid="element" label="Семейная" />
);

FamilyOwner.args = {
  cardNumber: '•• 4100',
  bank: CardBank.BelinvestBank,
  paymentSystem: CardSystem.JCB,
};

FamilyOwner.argTypes = {
  bank: {
    control: { type: 'select' },
    options: Object.values(CardBank),
  },
  paymentSystem: {
    control: { type: 'select' },
    options: Object.values(CardSystem),
  },
  cardNumber: {
    control: 'text',
    required: true,
  },
};
