import React from 'react';

import { Story } from '@storybook/react';

import { BankCardPreviewDefaultProps } from '../BankCard@types';
import { BankCardPreview } from '../BankCardPreview';
import { BankCardType, CardBank } from '../constants';

type PreviewArgs = Omit<BankCardPreviewDefaultProps, 'bankCardType'>;

export const PreviewStatefull: Story<PreviewArgs> = (args) => (
  <BankCardPreview bankCardType={BankCardType.Default} {...args} data-testid="element" />
);

PreviewStatefull.args = {
  bank: CardBank.BelinvestBank,
};

PreviewStatefull.argTypes = {
  bank: {
    control: { type: 'select' },
    options: Object.values(CardBank),
    required: true,
  },
};
