import React from 'react';

import {
  AkbarsDefaultIcon,
  AlfaBlackIcon,
  AmericanexrpessDefaultIcon,
  ApplepayWhiteIcon,
  AtbDefaultIcon,
  AvangardWhiteIcon,
  BaltinvestWhiteIcon,
  BelarusbankDefaultIcon,
  BelinvestbankDefaultIcon,
  BinbankWhiteIcon,
  CenterinvestDefaultIcon,
  CitibankWhiteIcon,
  CrediteuropaDefaultIcon,
  DinersDefaultIcon,
  DiscoverOnDarkIcon,
  ExpobankDefaultIcon,
  ExpressDefaultIcon,
  FinserviceWhiteIcon,
  FnpWhiteIcon,
  GazpromWhiteIcon,
  GlobexDefaultIcon,
  GooglepayOnDarkIcon,
  HomecreditbankDefaultIcon,
  IntercommerzOnDarkIcon,
  IntezaWhiteIcon,
  JcbDefaultIcon,
  JugraDefaultIcon,
  KaspibankDefaultIcon,
  LevoberezhnyDefaultIcon,
  MaestroDefaultIcon,
  MastercardDefaultIcon,
  MdmDefaultIcon,
  MfkDefaultIcon,
  MinbankDefaultIcon,
  MirDefaultIcon,
  ModulbankOnDarkIcon,
  MoscreditWhiteIcon,
  MtbWhiteIcon,
  MtsWhiteIcon,
  NovikombankWhiteIcon,
  OptbankOnDarkIcon,
  OrientDefaultIcon,
  OtkrityeDefaultIcon,
  PochtabankDefaultIcon,
  PriorbankDefaultIcon,
  PsbOnDarkIcon,
  QazkomWhiteIcon,
  QiwiWhiteIcon,
  RaifDefaultIcon,
  RencreditDefaultIcon,
  RgsWhiteIcon,
  RnkbDefaultIcon,
  RocketbankDefaultIcon,
  RosbankDefaultIcon,
  RosselhozOnDarkIcon,
  RossiyaDefaultIcon,
  RoundbankDefaultIcon,
  RusstandartWhiteIcon,
  SberWhiteIcon,
  SkbDefaultIcon,
  SmpWhiteIcon,
  SovkomWhiteIcon,
  SoyuzDefaultIcon,
  SpbWhiteIcon,
  SwedbankWhiteIcon,
  TatfondbankWhiteIcon,
  TinkoffDefaultIcon,
  TkbDefaultIcon,
  UnicreditDefaultIcon,
  UralbankWhiteIcon,
  UralsibWhiteIcon,
  UzcardDefaultIcon,
  VbankWhiteIcon,
  VbrRWhiteIcon,
  VisaDefaultIcon,
  VisaelectronDefaultIcon,
  VneshprombankWhiteIcon,
  VtbWhiteIcon,
  YoomoneyWhiteIcon,
  ZenitDefaultIcon,
} from '@yandex-id/icons';

export enum BankCardType {
  Default = 'Default',
  FamilyMember = 'FamilyMember',
}

export enum BankIconSize {
  S = 24,
  L = 32,
}

const CardSystemSizes: Record<'l' | 's', { height: number; width: number }> = {
  l: {
    height: 24,
    width: 36,
  },
  s: {
    height: 16,
    width: 24,
  },
};

export enum CardSystem {
  AmericanExpress = 'americanexpress',
  ApplePay = 'applepay',
  UnionPay = 'chinaunionpay',
  DinersClub = 'diners',
  Discover = 'discover',
  GooglePay = 'googlepay',
  JCB = 'jcb',
  Maestro = 'maestro',
  Mastercard = 'mastercard',
  MIR = 'mir',
  Uzcard = 'uzcard',
  Visa = 'visa',
  VisaElectron = 'visaelectron',
}

export enum CardBank {
  Akbars = 'akbars',
  Alfa = 'alfa',
  ATB = 'atb',
  AvangardBank = 'avangard',
  Baltinvest = 'baltinvest',
  BankMoskvi = 'bankmoskvi',
  BelarusBank = 'belarusbank',
  BelinvestBank = 'belinvestbank',
  BinBank = 'binbank',
  Centerinvest = 'centerinvest',
  CitiBank = 'citibank',
  CreditEuropa = 'crediteuropa',
  ExpoBank = 'expobank',
  Express = 'express',
  Finservice = 'finservice',
  FNP = 'fnp',
  Gazprom = 'gazprom',
  Globex = 'globex',
  HomecreditBank = 'homecreditbank',
  Intercommerz = 'intercommerz',
  Inteza = 'inteza',
  Jugra = 'jugra',
  KaspiBank = 'kaspibank',
  Levoberezhny = 'levoberezhny',
  MDM = 'mdm',
  MFK = 'mfk',
  MinBank = 'minbank',
  ModulBank = 'modulbank',
  Moscredit = 'moscredit',
  MTB = 'mtb',
  MTS = 'mts',
  NovikomBank = 'novikombank',
  OptBank = 'optbank',
  Orient = 'orient',
  Otkritye = 'otkritye',
  PochtaBank = 'pochtabank',
  PriorBank = 'priorbank',
  PSB = 'psb',
  Qazkom = 'qazkom',
  Qiwi = 'qiwi',
  Raif = 'raif',
  Rencredit = 'rencredit',
  RGS = 'rgs',
  RNKB = 'rnkb',
  RocketBank = 'rocketbank',
  RosBank = 'rosbank',
  Rosselhoz = 'rosselhoz',
  Rossiya = 'rossiya',
  Roundbank = 'roundbank',
  Russtandart = 'russtandart',
  Sber = 'sber',
  SKB = 'skb',
  SMP = 'smp',
  Sovkom = 'sovkom',
  Soyuz = 'soyuz',
  SPB = 'spb',
  SwedBank = 'swedbank',
  TatfondBank = 'tatfondbank',
  Tinkoff = 'tinkoff',
  TKB = 'tkb',
  Unicredit = 'unicredit',
  UralBank = 'uralbank',
  Uralsib = 'uralsib',
  VBank = 'vbank',
  VBRR = 'vbrR',
  Vneshprombank = 'vneshprombank',
  VTB = 'vtb',
  YooMoney = 'yoomoney',
  Zenit = 'zenit',
  Unknown = 'unknown',
}

interface BankColorsType {
  backgroundColor: string;
  textColor: string;
}

export const BankColors: Record<CardBank, BankColorsType> = {
  akbars: { backgroundColor: '#222', textColor: '#fff' },
  alfa: { backgroundColor: '#ef3124', textColor: '#000' },
  atb: { backgroundColor: '#222', textColor: '#fff' },
  avangard: { backgroundColor: '#00733c', textColor: '#fff' },
  baltinvest: { backgroundColor: '#222', textColor: '#fff' },
  bankmoskvi: { backgroundColor: '#222', textColor: '#fff' },
  belarusbank: { backgroundColor: '#00733c', textColor: '#fff' },
  belinvestbank: { backgroundColor: '#222', textColor: '#fff' },
  binbank: { backgroundColor: '#334a9d', textColor: '#fff' },
  centerinvest: { backgroundColor: '#222', textColor: '#fff' },
  citibank: { backgroundColor: '#0f3173', textColor: '#fff' },
  crediteuropa: { backgroundColor: '#222', textColor: '#fff' },
  expobank: { backgroundColor: '#222', textColor: '#fff' },
  express: { backgroundColor: '#222', textColor: '#fff' },
  finservice: { backgroundColor: '#222', textColor: '#fff' },
  fnp: { backgroundColor: '#222', textColor: '#fff' },
  gazprom: { backgroundColor: '#222', textColor: '#fff' },
  globex: { backgroundColor: '#222', textColor: '#fff' },
  homecreditbank: { backgroundColor: '#2ecdff', textColor: '#fff' },
  intercommerz: { backgroundColor: '#222', textColor: '#fff' },
  inteza: { backgroundColor: '#222', textColor: '#fff' },
  jugra: { backgroundColor: '#222', textColor: '#fff' },
  kaspibank: { backgroundColor: '#750317', textColor: '#fff' },
  levoberezhny: { backgroundColor: '#222', textColor: '#fff' },
  mdm: { backgroundColor: '#222', textColor: '#fff' },
  mfk: { backgroundColor: '#222', textColor: '#fff' },
  minbank: { backgroundColor: '#222', textColor: '#fff' },
  modulbank: { backgroundColor: '#0a267b', textColor: '#fff' },
  moscredit: { backgroundColor: '#750317', textColor: '#fff' },
  mtb: { backgroundColor: '#222', textColor: '#fff' },
  mts: { backgroundColor: '#e30611', textColor: '#fff' },
  novikombank: { backgroundColor: '#222', textColor: '#fff' },
  optbank: { backgroundColor: '#222', textColor: '#fff' },
  orient: { backgroundColor: '#bb3800', textColor: '#fff' },
  otkritye: { backgroundColor: '#acb0c1', textColor: '#fff' },
  pochtabank: { backgroundColor: '#f1f2f5', textColor: '#000' },
  priorbank: { backgroundColor: '#828d94', textColor: '#fff' },
  psb: { backgroundColor: '#6831a6', textColor: '#fff' },
  qazkom: { backgroundColor: '#007db2', textColor: '#fff' },
  qiwi: { backgroundColor: '#ff9b29', textColor: '#fff' },
  raif: { backgroundColor: '#fee600', textColor: '#000' },
  rencredit: { backgroundColor: '#222', textColor: '#fff' },
  rgs: { backgroundColor: '#222', textColor: '#fff' },
  rnkb: { backgroundColor: '#f1f2f5', textColor: '#000' },
  rocketbank: { backgroundColor: '#222', textColor: '#fff' },
  rosbank: { backgroundColor: '#acb0c1', textColor: '#fff' },
  rosselhoz: { backgroundColor: '#00733c', textColor: '#fff' },
  rossiya: { backgroundColor: '#f1f2f5', textColor: '#000' },
  roundbank: { backgroundColor: '#222', textColor: '#fff' },
  russtandart: { backgroundColor: '#222', textColor: '#fff' },
  sber: { backgroundColor: '#21a038', textColor: '#fff' },
  skb: { backgroundColor: '#f1f2f5', textColor: '#000' },
  smp: { backgroundColor: '#222', textColor: '#fff' },
  sovkom: { backgroundColor: '#3441b5', textColor: '#fff' },
  soyuz: { backgroundColor: '#222', textColor: '#fff' },
  spb: { backgroundColor: '#297bd1', textColor: '#fff' },
  swedbank: { backgroundColor: '#fd8000', textColor: '#fff' },
  tatfondbank: { backgroundColor: '#222', textColor: '#fff' },
  tinkoff: { backgroundColor: '#222', textColor: '#fff' },
  tkb: { backgroundColor: '#222', textColor: '#fff' },
  unicredit: { backgroundColor: '#f1f2f5', textColor: '#000' },
  uralbank: { backgroundColor: '#9e62af', textColor: '#fff' },
  uralsib: { backgroundColor: '#222', textColor: '#fff' },
  vbank: { backgroundColor: '#242554', textColor: '#fff' },
  vbrR: { backgroundColor: '#222', textColor: '#fff' },
  vneshprombank: { backgroundColor: '#222', textColor: '#fff' },
  vtb: { backgroundColor: '#3995ea', textColor: '#fff' },
  yoomoney: { backgroundColor: '#8b3ffd', textColor: '#fff' },
  zenit: { backgroundColor: '#222', textColor: '#fff' },
  unknown: { backgroundColor: '#222', textColor: '#fff' },
};

export const getCardBankIcon = (bank: CardBank, size: 24 | 32 = 24) => {
  switch (bank) {
    case CardBank.Akbars:
      return <AkbarsDefaultIcon size={size} />;
    case CardBank.Alfa:
      return <AlfaBlackIcon size={size} />;
    case CardBank.ATB:
      return <AtbDefaultIcon size={size} />;
    case CardBank.AvangardBank:
      return <AvangardWhiteIcon size={size} />;
    case CardBank.Baltinvest:
      return <BaltinvestWhiteIcon size={size} />;
    case CardBank.BelarusBank:
      return <BelarusbankDefaultIcon size={size} />;
    case CardBank.BelinvestBank:
      return <BelinvestbankDefaultIcon size={size} />;
    case CardBank.BinBank:
      return <BinbankWhiteIcon size={size} />;
    case CardBank.Centerinvest:
      return <CenterinvestDefaultIcon size={size} />;
    case CardBank.CitiBank:
      return <CitibankWhiteIcon size={size} />;
    case CardBank.CreditEuropa:
      return <CrediteuropaDefaultIcon size={size} />;
    case CardBank.ExpoBank:
      return <ExpobankDefaultIcon size={size} />;
    case CardBank.Express:
      return <ExpressDefaultIcon size={size} />;
    case CardBank.Finservice:
      return <FinserviceWhiteIcon size={size} />;
    case CardBank.FNP:
      return <FnpWhiteIcon size={size} />; //
    case CardBank.Gazprom:
      return <GazpromWhiteIcon size={size} />;
    case CardBank.Globex:
      return <GlobexDefaultIcon size={size} />;
    case CardBank.HomecreditBank:
      return <HomecreditbankDefaultIcon size={size} />;
    case CardBank.Intercommerz:
      return <IntercommerzOnDarkIcon size={size} />;
    case CardBank.Inteza:
      return <IntezaWhiteIcon size={size} />;
    case CardBank.Jugra:
      return <JugraDefaultIcon size={size} />;
    case CardBank.KaspiBank:
      return <KaspibankDefaultIcon size={size} />;
    case CardBank.Levoberezhny:
      return <LevoberezhnyDefaultIcon size={size} />;
    case CardBank.MDM:
      return <MdmDefaultIcon size={size} />;
    case CardBank.MFK:
      return <MfkDefaultIcon size={size} />;
    case CardBank.MinBank:
      return <MinbankDefaultIcon size={size} />;
    case CardBank.ModulBank:
      return <ModulbankOnDarkIcon size={size} />;
    case CardBank.Moscredit:
      return <MoscreditWhiteIcon size={size} />;
    case CardBank.MTB:
      return <MtbWhiteIcon size={size} />;
    case CardBank.MTS:
      return <MtsWhiteIcon size={size} />;
    case CardBank.NovikomBank:
      return <NovikombankWhiteIcon size={size} />;
    case CardBank.OptBank:
      return <OptbankOnDarkIcon size={size} />;
    case CardBank.Orient:
      return <OrientDefaultIcon size={size} />;
    case CardBank.Otkritye:
      return <OtkrityeDefaultIcon size={size} />;
    case CardBank.PochtaBank:
      return <PochtabankDefaultIcon size={size} />;
    case CardBank.PriorBank:
      return <PriorbankDefaultIcon size={size} />;
    case CardBank.PSB:
      return <PsbOnDarkIcon size={size} />;
    case CardBank.Qazkom:
      return <QazkomWhiteIcon size={size} />;
    case CardBank.Qiwi:
      return <QiwiWhiteIcon size={size} />;
    case CardBank.Raif:
      return <RaifDefaultIcon size={size} />;
    case CardBank.Rencredit:
      return <RencreditDefaultIcon size={size} />;
    case CardBank.RGS:
      return <RgsWhiteIcon size={size} />;
    case CardBank.RNKB:
      return <RnkbDefaultIcon size={size} />;
    case CardBank.RocketBank:
      return <RocketbankDefaultIcon size={size} />;
    case CardBank.RosBank:
      return <RosbankDefaultIcon size={size} />;
    case CardBank.Rosselhoz:
      return <RosselhozOnDarkIcon size={size} />;
    case CardBank.Rossiya:
      return <RossiyaDefaultIcon size={size} />;
    case CardBank.Roundbank:
      return <RoundbankDefaultIcon size={size} />;
    case CardBank.Russtandart:
      return <RusstandartWhiteIcon size={size} />;
    case CardBank.Sber:
      return <SberWhiteIcon size={size} />;
    case CardBank.SKB:
      return <SkbDefaultIcon size={size} />;
    case CardBank.SMP:
      return <SmpWhiteIcon size={size} />;
    case CardBank.Sovkom:
      return <SovkomWhiteIcon size={size} />;
    case CardBank.Soyuz:
      return <SoyuzDefaultIcon size={size} />;
    case CardBank.SPB:
      return <SpbWhiteIcon size={size} />;
    case CardBank.SwedBank:
      return <SwedbankWhiteIcon size={size} />;
    case CardBank.TatfondBank:
      return <TatfondbankWhiteIcon size={size} />;
    case CardBank.Tinkoff:
      return <TinkoffDefaultIcon size={size} />;
    case CardBank.TKB:
      return <TkbDefaultIcon size={size} />;
    case CardBank.Unicredit:
      return <UnicreditDefaultIcon size={size} />;
    case CardBank.UralBank:
      return <UralbankWhiteIcon size={size} />;
    case CardBank.Uralsib:
      return <UralsibWhiteIcon size={size} />;
    case CardBank.VBank:
      return <VbankWhiteIcon size={size} />;
    case CardBank.VBRR:
      return <VbrRWhiteIcon size={size} />;
    case CardBank.Vneshprombank:
      return <VneshprombankWhiteIcon size={size} />;
    case CardBank.VTB:
      return <VtbWhiteIcon size={size} />;
    case CardBank.YooMoney:
      return <YoomoneyWhiteIcon size={size} />;
    case CardBank.Zenit:
      return <ZenitDefaultIcon size={size} />;
  }
};

export const getCardSystemIcon = (system: CardSystem, size: 'l' | 's' = 'l') => {
  switch (system) {
    case CardSystem.AmericanExpress:
      return <AmericanexrpessDefaultIcon {...CardSystemSizes[size]} />;
    case CardSystem.ApplePay:
      return <ApplepayWhiteIcon {...CardSystemSizes[size]} />;
    case CardSystem.UnionPay:
      return <UnicreditDefaultIcon {...CardSystemSizes[size]} />;
    case CardSystem.DinersClub:
      return <DinersDefaultIcon {...CardSystemSizes[size]} />;
    case CardSystem.Discover:
      return <DiscoverOnDarkIcon {...CardSystemSizes[size]} />;
    case CardSystem.GooglePay:
      return <GooglepayOnDarkIcon {...CardSystemSizes[size]} />;
    case CardSystem.JCB:
      return <JcbDefaultIcon {...CardSystemSizes[size]} />;
    case CardSystem.Maestro:
      return <MaestroDefaultIcon {...CardSystemSizes[size]} />;
    case CardSystem.Mastercard:
      return <MastercardDefaultIcon {...CardSystemSizes[size]} />;
    case CardSystem.MIR:
      return <MirDefaultIcon {...CardSystemSizes[size]} />;
    case CardSystem.Uzcard:
      return <UzcardDefaultIcon {...CardSystemSizes[size]} />;
    case CardSystem.Visa:
      return <VisaDefaultIcon {...CardSystemSizes[size]} />;
    case CardSystem.VisaElectron:
      return <VisaelectronDefaultIcon {...CardSystemSizes[size]} />;
  }
};
