import React from 'react';

import { Meta, Story } from '@storybook/react';

import { Button, IButtonProps } from '.';
import { Icon } from '../Icon';

export * from './__examples__/Button.Add.stories';
export * from './__examples__/Button.Find.stories';

interface ITemplateProps extends Omit<IButtonProps, 'icon' | 'size'> {
  iconPosition: string;
  icon: 'addDoc' | 'arrowRight' | 'type-check';
  size: 's' | 'm' | 'l';
  text: string;
}

const iconMap = {
  addDoc: (className: string) => <Icon className={className} glyph="addDocument" />,
  arrowRight: (className: string) => <Icon className={className} type="arrowRight" />,
  'type-check': (className: string) => <Icon className={className} glyph="type-check" />,
};

export default {
  id: 'Button',
  title: 'Components/Button',
  component: Button,
  args: {
    view: 'raised',
    size: 'l',
    text: 'Добавить документ',
    pin: 'circle-circle',
  },
  argTypes: {
    view: {
      control: {
        type: 'select',
        options: ['default', 'action', 'clear', 'link', 'pseudo', 'raised'],
      },
      defaultValue: 'raised',
    },
    iconPosition: {
      control: {
        type: 'select',
        options: ['left', 'inside', 'right'],
      },
      defaultValue: 'left',
    },
    size: {
      control: {
        type: 'select',
        options: ['s', 'm', 'l'],
      },
      defaultValue: 'l',
    },
    icon: {
      control: {
        type: 'select',
        options: Object.keys(iconMap),
      },
      defaultValue: 'addDoc',
    },
    iconLeft: { table: { disable: true } },
    iconRight: { table: { disable: true } },
  },
} as Meta;

const Template: Story<ITemplateProps> = ({ text, iconPosition, icon, iconLeft, ...args }) => {
  const iconProp =
    // eslint-disable-next-line no-nested-ternary
    iconPosition === 'left' ? 'iconLeft' : iconPosition === 'right' ? 'iconRight' : 'icon';

  const props = {
    ...args,
    [iconProp]: iconMap[icon],
  } as IButtonProps;

  return <Button {...props}>{text}</Button>;
};

export const Default = Template.bind({});

Default.args = {};
