import React from 'react';

import { compose, composeU } from '@bem-react/core';
import {
  Button as ButtonDesktop,
  IButtonPinCircleCircleProps,
  IButtonSizeLProps,
  IButtonSizeMProps,
  IButtonSizeSProps,
  IButtonTypeLinkProps,
  IButtonTypeSubmitProps,
  IButtonViewActionProps,
  IButtonViewDefaultProps,
  IButtonViewPseudoProps,
  IButtonWidthAutoProps,
  IButtonWidthMaxProps,
  IButtonProps as ILegoButtonProps,
  withPinCircleCircle,
  withSizeL,
  withSizeM,
  withSizeS,
  withTypeLink,
  withTypeSubmit,
  withViewAction,
  withViewDefault,
  withViewPseudo,
  withWidthAuto,
  withWidthMax,
} from '@yandex-lego/components/Button/desktop';

import './Button.css';

const LegoButton = compose(
  composeU(withTypeLink, withTypeSubmit),
  composeU(withSizeS, withSizeL, withSizeM),
  composeU(withViewDefault, withViewAction, withViewPseudo),
  composeU(withPinCircleCircle),
  composeU(withWidthMax, withWidthAuto),
)(ButtonDesktop);

type TypeProps = IButtonTypeLinkProps | IButtonTypeSubmitProps;

type SizeProps = IButtonSizeSProps | IButtonSizeMProps | IButtonSizeLProps;

type ViewProps = IButtonViewDefaultProps | IButtonViewActionProps | IButtonViewPseudoProps;

type PinProps = IButtonPinCircleCircleProps;

type WidthProps = IButtonWidthAutoProps | IButtonWidthMaxProps;

export type IButtonProps = ILegoButtonProps &
  TypeProps &
  SizeProps &
  ViewProps &
  PinProps &
  WidthProps;

export const Button: React.FC<IButtonProps> = (props) => {
  const { view = 'default', size = 'm', ...restProps } = props;

  return (
    <LegoButton view={view} size={size} {...restProps}>
      {props.children}
    </LegoButton>
  );
};
