import React from 'react';

import { Story } from '@storybook/react';

import { Button, IButtonProps } from '..';
import { Icon } from '../../Icon';

import './Button.Add.stories.css';

const Template: Story<IButtonProps> = () => {
  return (
    <div style={{ width: '300px' }}>
      <Button
        className="SuperButton"
        view="pseudo"
        width="auto"
        pin="circle-circle"
        icon={(className: string) => <Icon className={className} glyph="plus" />}
        // @ts-expect-error
        style={{ height: '100px' }}
      >
        Добавить фото
      </Button>
    </div>
  );
};

export const Add = Template.bind({});

Add.args = {};
