import React from 'react';

import { Story } from '@storybook/react';
import { Icon } from '@yandex-id/components';

import { ListItemView } from '../../ListItemView';
import { Text } from '../../Text';
import { Card } from '../Card';

import './base-story-styles.css';

const listItems = new Array(5).fill(null).map((_, index) => `Item ${index + 1}`);

export const Default: Story = () => {
  return (
    <div className="story">
      <Card>
        <div className="section-caption">Card heading</div>
        {listItems.map((item) => (
          <ListItemView alignItems="center" key={item}>
            <ListItemView.Before>
              <Icon type="passport" />
            </ListItemView.Before>

            <ListItemView.Content>
              <Text variant="text-m" color="primary">
                {item}
              </Text>
            </ListItemView.Content>
          </ListItemView>
        ))}
      </Card>
      <Card>
        <div className="section-caption">Card heading</div>
        {listItems.map((item) => (
          <ListItemView alignItems="center" key={item}>
            <ListItemView.Before>
              <Icon type="passport" />
            </ListItemView.Before>

            <ListItemView.Content>
              <Text variant="text-m" color="primary">
                {item}
              </Text>
            </ListItemView.Content>
          </ListItemView>
        ))}
      </Card>
    </div>
  );
};
