import { getCSSDirection, getChildrenSortedByPx, getComputedProps } from '../Carousel.libs';
import type { GetElement, GetVisible } from '../Carousel@types';
import { UseArrowButtonProps, useArrowButton } from './useArrowButton';

const getVisible: GetVisible = (root) => {
  const style = getComputedStyle(root);

  return getCSSDirection(style) === 'ltr'
    ? root.scrollLeft > 0
    : root.scrollLeft > root.clientWidth - root.scrollWidth;
};

const getElement: GetElement = (root) => {
  const { direction, startPosition, shift } = getComputedProps(root);
  const leftPosition = startPosition - shift;

  const leftPart = [];
  const centralPart = [];
  const rightPart = [];

  for (const { rect, child } of getChildrenSortedByPx(root)) {
    const left = Math.round(rect.left);

    if (left < leftPosition) {
      leftPart.push(child);
    } else if (left < startPosition) {
      centralPart.push(child);
    } else {
      rightPart.push(child);
    }
  }

  // если элемент очень широкий
  if (centralPart.length === 0 && leftPart.length > 0) {
    centralPart.unshift(leftPart.pop());
  }

  return (direction === 'rtl' && leftPart.at(-1)) || centralPart[0] || rightPart[0];
};

export interface UseBackArrowButtonProps {
  scrollableElementRef: UseArrowButtonProps['scrollableElementRef'];
}

export function useBackArrowButton(props: UseBackArrowButtonProps) {
  return useArrowButton({
    scrollableElementRef: props.scrollableElementRef,
    getVisible,
    getElement,
  });
}
