import { getCSSDirection, getChildrenSortedByPx, getComputedProps } from '../Carousel.libs';
import type { GetElement, GetVisible } from '../Carousel@types';
import { UseArrowButtonProps, useArrowButton } from './useArrowButton';

const getVisible: GetVisible = (root) => {
  const style = getComputedStyle(root);

  return getCSSDirection(style) === 'ltr'
    ? root.scrollLeft < root.scrollWidth - root.clientWidth
    : root.scrollLeft < 0;
};

const getElement: GetElement = (root) => {
  const { direction, startPosition, shift } = getComputedProps(root);
  const rightPosition = startPosition + shift;

  const leftPart = [];
  const centralPart = [];
  const rightPart = [];

  for (const { rect, child } of getChildrenSortedByPx(root)) {
    const right = Math.round(rect.right);

    if (right <= startPosition) {
      leftPart.push(child);
    } else if (right <= rightPosition) {
      centralPart.push(child);
    } else {
      rightPart.push(child);
    }
  }

  // если элемент очень широкий
  if (centralPart.length === 0 && rightPart.length > 0) {
    centralPart.push(rightPart.shift());
  }

  return (direction === 'ltr' && rightPart[0]) || centralPart.at(-1) || leftPart.at(-1);
};

export interface UseForwardArrowButtonProps {
  scrollableElementRef: UseArrowButtonProps['scrollableElementRef'];
}

export function useForwardArrowButton(props: UseForwardArrowButtonProps) {
  return useArrowButton({
    scrollableElementRef: props.scrollableElementRef,
    getVisible,
    getElement,
  });
}
