export function getCSSScrollPaddingInlineStart(style: CSSStyleDeclaration): number {
  const paddingStart = style.getPropertyValue('scroll-padding-inline-start') || '0px';

  if (!paddingStart.endsWith('px')) {
    throw new TypeError('Invalid value');
  }

  return parseFloat(paddingStart);
}
