interface Item {
  child: HTMLElement;
  rect: DOMRect;
}

type Items = Item[];

export function getChildrenSortedByPx(root: HTMLElement): Items {
  const { children } = root;

  const items: Items = [];

  for (let i = 0; i < children.length; ++i) {
    const child = children[i] as HTMLElement;

    items.push({
      child,
      rect: child.getBoundingClientRect(),
    });
  }

  return items.sort((item1, item2) => item1.rect.left - item2.rect.left);
}
