import { getCSSDirection } from './getCSSDirection';
import { getCSSScrollPaddingInlineStart } from './getCSSScrollPaddingInlineStart';

interface ComputedProps {
  direction: 'ltr' | 'rtl';
  startPosition: number;
  shift: number;
}

export function getComputedProps(root: HTMLElement): ComputedProps {
  const style = getComputedStyle(root);

  const direction = getCSSDirection(style);
  const scrollPaddingInlineStart = getCSSScrollPaddingInlineStart(style);

  const { left, right, width } = root.getBoundingClientRect();

  return {
    direction,
    startPosition: Math.round(
      direction === 'ltr' ? left + scrollPaddingInlineStart : right - scrollPaddingInlineStart,
    ),
    shift: Math.round(width - scrollPaddingInlineStart),
  };
}
