import classNames from 'classnames';
import React, { ComponentPropsWithoutRef, FC, useRef } from 'react';

import { ArrowLongBack, ArrowLongForward } from '@yandex/ui-icons';

import { Button } from '../../next';
import { useBackArrowButton, useForwardArrowButton } from './Carousel.hooks';

import styles from './Carousel.module.css';

export type CarouselProps = ComponentPropsWithoutRef<'div'>;

export const Carousel: FC<CarouselProps> = ({ children, className, ...props }) => {
  const scrollableElementRef = useRef<HTMLUListElement>(null);

  const { isVisible: isBackArrowButtonVisible, buttonProps: backArrowButtonProps } =
    useBackArrowButton({ scrollableElementRef });
  const { isVisible: isForwardArrowButtonVisible, buttonProps: forwardArrowButtonProps } =
    useForwardArrowButton({ scrollableElementRef });

  return (
    <div {...props} className={classNames(styles.root, className)}>
      <div className={styles.box}>
        <ul ref={scrollableElementRef} className={styles.items}>
          {children}
        </ul>
      </div>
      {isBackArrowButtonVisible && (
        <Button
          {...backArrowButtonProps}
          size="xl"
          variant="raised"
          className={styles.backArrowButton}
          aria-hidden="true"
        >
          <ArrowLongBack />
        </Button>
      )}
      {isForwardArrowButtonVisible && (
        <Button
          {...forwardArrowButtonProps}
          size="xl"
          variant="raised"
          className={styles.forwardArrowButton}
          aria-hidden="true"
        >
          <ArrowLongForward />
        </Button>
      )}
    </div>
  );
};
