import classNames from 'classnames';
import React, { ComponentPropsWithoutRef, FC } from 'react';

import styles from './CarouselItem.module.css';

export type CarouselItemProps = ComponentPropsWithoutRef<'li'>;

export const CarouselItem: FC<CarouselItemProps> = ({ className, ...props }) => (
  <li {...props} className={classNames(styles.root, className)} />
);
