import React, { CSSProperties, FC } from 'react';

import type { Story } from '@storybook/react';
import { Carousel, CarouselItem, CarouselProps } from '@yandex-id/components';

interface RectangleProps {
  width?: CSSProperties['width'];
}

const Rectangle: FC<RectangleProps> = ({ width = 200, ...props }) => (
  <div
    {...props}
    style={{
      width,
      height: 100,
      borderRadius: 10,
      backgroundColor: '#bbb',
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center',
      fontSize: '3em',
      fontWeight: 'bold',
      color: '#888',
    }}
  />
);

type DefaultArgs = CarouselProps;

export const Default: Story<DefaultArgs> = (args) => (
  <Carousel {...args} style={{ marginRight: 25, marginLeft: 25 }}>
    <CarouselItem>
      <Rectangle>A</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>B 1</Rectangle>
      <Rectangle>B 2</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>C</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>D</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>E</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>F</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>G</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>H</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>I</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>J</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>K</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>L</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>M</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>N</Rectangle>
    </CarouselItem>
    <CarouselItem style={{ width: '101%' }}>
      <Rectangle width="100%">O</Rectangle>
    </CarouselItem>
    <CarouselItem style={{ width: '100%' }}>
      <Rectangle width="100%">P</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>Q</Rectangle>
    </CarouselItem>
    <CarouselItem style={{ width: '100%' }}>
      <Rectangle width="50%">R 1</Rectangle>
      <Rectangle width="50%">R 2</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>S</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle width={150}>T</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle>U</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle width={100}>V</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle width={50}>W</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle width={100}>X</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle width={100}>Y</Rectangle>
    </CarouselItem>
    <CarouselItem>
      <Rectangle width={100}>Z</Rectangle>
    </CarouselItem>
  </Carousel>
);

Default.args = {};

Default.argTypes = {};
