import cx from 'classnames';
import React, { forwardRef, useRef } from 'react';

import { useForwardedRef } from '@use-platform/react';

import { CodeSegment, UseCodeFieldStateResult, useCodeFieldInput } from '../../../libs/code-field';

import styles from './Segment.module.css';

export interface SegmentProps extends CodeSegment {
  className?: string;
  state: UseCodeFieldStateResult;
  type?: string;
  inputMode?: 'numeric' | 'text';
  disabled?: boolean;
  invalid?: boolean;
}

export const Segment = forwardRef<HTMLInputElement, SegmentProps>(function Segment(
  props,
  forwardedRef,
) {
  const { state, invalid, className, ...otherProps } = props;
  const { value, selected, disabled } = otherProps;
  const isFocused = state.focused && selected;
  const ref = useRef<HTMLInputElement>(null);

  useForwardedRef(ref, forwardedRef);

  const { inputProps } = useCodeFieldInput(otherProps, state, ref);

  return (
    <span
      className={cx(
        styles.root,
        {
          [styles.root_isEmpty]: value.length === 0,
          [styles.root_isFocused]: isFocused,
          [styles.root_isDisabled]: disabled,
          [styles.root_isInvalid]: invalid,
        },
        className,
      )}
    >
      <input className={styles.control} ref={ref} {...inputProps} />
    </span>
  );
});
