import React, { useState } from 'react';

import type { Story } from '@storybook/react';
import { mergeProps } from '@use-platform/react';
import { CodeField, CodeFieldProps } from '@yandex-id/components';

type DefaultArgs = CodeFieldProps;

export const Default: Story<DefaultArgs> = (args) => {
  const [value, onChange] = useState('');

  const baseProps = { value, onChange };

  return <CodeField {...mergeProps(args, baseProps)} />;
};

Default.argTypes = {
  type: {
    control: {
      type: 'select',
    },
    options: ['text', 'number', 'password'],
  },
  codeLength: {
    control: { type: 'number', min: 1, max: 12, step: 1 },
  },
  formatBy: {
    control: { type: 'number', min: 0, step: 1 },
  },
  inputMode: {
    control: {
      type: 'select',
    },
    options: ['text', 'numeric'],
  },
  onComplete: {
    action: 'onComplete',
  },
  onChange: {
    action: 'onChange',
  },
};

Default.args = {
  disabled: false,
  invalid: false,
};
