import React, { useCallback, useState } from 'react';

import type { Story } from '@storybook/react';
import { DateInputChangeEvent } from '@use-platform/react';
import { DateTimeField } from '@yandex-id/components';

interface DefaultArgs {
  disabled: boolean;
  size: 's' | 'm' | 'l' | 'xl';
  max?: number | Date;
  min?: number | Date;
}

export const Default: Story<DefaultArgs> = (args) => {
  const [value, setValue] = useState<Date | null>(null);
  const onValueChange = useCallback(
    (event: DateInputChangeEvent<Date | null>) => {
      setValue(event.value);
    },
    [setValue],
  );

  return (
    <div data-testid="story">
      <DateTimeField {...args} value={value} onChange={onValueChange} data-testid="input" />
    </div>
  );
};

Default.args = {
  disabled: false,
  size: 'm',
};

Default.argTypes = {
  size: {
    control: {
      type: 'select',
    },
    options: ['s', 'm', 'l', 'xl'],
  },
  max: {
    control: {
      type: 'date',
    },
  },
  min: {
    control: {
      type: 'date',
    },
  },
};
