import { DateTimeField as LegoDateTimeField } from '@yandex-lego/components/next/DateTimeField/desktop';

import { component } from '../../libs/css-modules';

import styles from './DateTimeField.module.css';
import sizeL from './_size/size-l.module.css';
import sizeM from './_size/size-m.module.css';
import sizeS from './_size/size-s.module.css';
import sizeXl from './_size/size-xl.module.css';

export const DateTimeField = component(LegoDateTimeField, {
  displayName: 'DateTimeField',
  defaultProps: {
    size: 'm',
  },
  variants: {
    size: {
      xl: sizeXl.root,
      l: sizeL.root,
      m: sizeM.root,
      s: sizeS.root,
    },
  },
  styles: styles.root,
});
