import React, { useCallback, useState } from 'react';

import { Story } from '@storybook/react';

import { Dialog, IDialogAutoProps } from '..';
import { Button } from '../../Button';

const Template: Story<IDialogAutoProps> = (args) => {
  const scopeRef = React.useRef<HTMLDivElement>(null);
  const [isVisible, setVisible] = useState(false);

  return (
    <div style={{ width: '360px' }} ref={scopeRef}>
      <Button
        view="default"
        pin="circle-circle"
        size="l"
        onClick={useCallback(() => setVisible(true), [])}
      >
        Открывайся!
      </Button>
      <Dialog
        {...args}
        drawer={{
          scope: scopeRef,
          visible: isVisible,
          onClose: () => setVisible(false),
        }}
        modal={{
          visible: isVisible,
          onClose: () => setVisible(false),
          zIndexGroupLevel: 20,
          withCloseCross: true,
        }}
      >
        Hello World!
      </Dialog>
    </div>
  );
};

export const Auto = Template.bind({});

Auto.args = {
  type: 'auto',
};

Auto.argTypes = {
  type: {
    control: {
      type: 'select',
      options: ['auto'],
    },
    defaultValue: 'auto',
  },
};
