import React, { useCallback, useState } from 'react';

import { Story } from '@storybook/react';

import { Dialog, IDialogDrawerProps } from '..';
import { Button } from '../../Button';

const Template: Story<IDialogDrawerProps> = (args) => {
  const scopeRef = React.useRef<HTMLDivElement>(null);
  const [isVisible, setVisible] = useState(false);

  return (
    <div style={{ width: '360px' }} ref={scopeRef}>
      <Button
        view="default"
        pin="circle-circle"
        size="l"
        onClick={useCallback(() => setVisible(true), [])}
      >
        Открывайся!
      </Button>
      <Dialog
        {...args}
        scope={scopeRef}
        visible={isVisible}
        onClose={useCallback(() => setVisible(false), [])}
      >
        Hello World!
      </Dialog>
    </div>
  );
};

export const Drawer = Template.bind({});

Drawer.args = {
  type: 'drawer',
};

Drawer.argTypes = {
  type: {
    control: {
      type: 'select',
      options: ['drawer'],
    },
    defaultValue: 'drawer',
  },
};
