import React, { useCallback, useState } from 'react';

import { Story } from '@storybook/react';

import { Dialog, IDialogModalProps } from '..';
import { Button } from '../../Button';

const Template: Story<IDialogModalProps> = (args) => {
  const scopeRef = React.useRef<HTMLDivElement>(null);
  const [isVisible, setVisible] = useState(false);

  return (
    <div style={{ width: '360px' }} ref={scopeRef}>
      <Button
        view="default"
        pin="circle-circle"
        size="l"
        onClick={useCallback(() => setVisible(true), [])}
      >
        Открывайся!
      </Button>
      <Dialog
        {...args}
        theme="normal"
        visible={isVisible}
        onClose={useCallback(() => setVisible(false), [])}
        zIndexGroupLevel={20}
      >
        Hello World!
      </Dialog>
    </div>
  );
};

export const Modal = Template.bind({});

Modal.args = {
  type: 'modal',
};

Modal.argTypes = {
  type: {
    control: {
      type: 'select',
      options: ['modal'],
    },
    defaultValue: 'modal',
  },
  withCloseCross: {
    control: {
      type: 'boolean',
    },
  },
};
