import React, { useEffect, useState } from 'react';

import { Meta, Story } from '@storybook/react';

import { Document } from '.';
import { IDocumentProps } from './Document.interface';

export default {
  id: 'Document',
  title: 'Components/Document',
  component: Document,
} as Meta;

const Template: Story<IDocumentProps> = (args) => {
  const [isLoading, setIsLoading] = useState(true);

  useEffect(() => {
    if (isLoading) {
      const timeoutFn = async () =>
        new Promise(() =>
          setTimeout(() => {
            setIsLoading(false);
          }, 2000),
        );

      timeoutFn();
    }
  }, [isLoading]);

  return <Document {...args} isLoading={isLoading} />;
};

export const Default = Template.bind({});

Default.args = {
  data: { id: 'passport', title: 'Паспорт РФ', isActive: false, description: '2 фото' },
};
