import React from 'react';

import { cn } from '@bem-react/classname';

import { Icon } from '../Icon/Icon';
import { IDocumentProps } from './Document.interface';
import { DocumentSkeleton } from './Skeleton/DocumentSkeleton';

import './Document.css';

const cnDocument = cn('Document');

export const Document: React.FC<IDocumentProps> = ({
  className,
  classNameSkeleton,
  isLoading,
  data,
  onClick,
}) => {
  const clsComponent = cnDocument(null, [className]);

  if (isLoading || !data) {
    return (
      <div className={clsComponent}>
        <DocumentSkeleton className={classNameSkeleton} />
      </div>
    );
  }

  const { id, title, isActive, description } = data;

  return (
    <div className={clsComponent} onClick={onClick}>
      <div className={cnDocument('Main')}>
        <div className={cnDocument('Icon')}>
          <Icon type={isActive ? id : `${id}_inactive`} />
        </div>
        <div className={cnDocument('Info')}>
          <div className={cnDocument('Name')}>
            <div className={cnDocument('Title')}>{title}</div>
          </div>
          {description && <div className={cnDocument('Description')}>{description}</div>}
        </div>
        {isActive ? <Icon type="arrowRight" /> : <Icon type="plus" />}
      </div>
    </div>
  );
};
