import React from 'react';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';
import { Rect, Text } from '@yandex-int/tap-components/Skeleton';

import './DocumentSkeleton.css';

const cnDocumentSkeleton = cn('DocumentSkeleton');

export type IDocumentSkeletonProps = IClassNameProps;

export const DocumentSkeleton: React.FC<IDocumentSkeletonProps> = ({ className }) => {
  return (
    <div className={cnDocumentSkeleton(null, [className])}>
      <Rect className={cnDocumentSkeleton('Icon')} width={44} height={44} borderRadius={12} />
      <Text className={cnDocumentSkeleton('Text')} width={160} size={16} />
    </div>
  );
};
