import React, { useState } from 'react';

import { Meta, Story } from '@storybook/react';

import { DrawerPhone, IDrawerPhoneProps } from '.';
import { Button } from '../Button';
import { Divider } from '../Divider/Divider';
import { Document } from '../Document';
import { Icon } from '../Icon';
import { List } from '../List';
import { ListGroups } from '../ListGroups/ListGroups';
import { ListItem } from '../ListItem/ListItem';

import './stories.css';

export default {
  id: 'DrawerPhone',
  title: 'Components/Drawer/Phone',
  component: DrawerPhone,
} as Meta;

const renderDrawerItem = (): JSX.Element[] => {
  const header = <Divider />;

  return [
    <ListItem key={0}>
      <Document data={{ id: 'snils', title: 'Паспорт РФ', isActive: true }} />
    </ListItem>,
    <ListItem key={1} header={header}>
      <Document data={{ id: 'snils', title: 'Паспорт РФ', isActive: true }} />
    </ListItem>,
  ];
};

const Template: Story<IDrawerPhoneProps> = (args) => {
  const scopeRef = React.useRef<HTMLDivElement>(null);
  const [isVisible, setVisible] = useState(false);

  return (
    <div style={{ width: '360px' }} ref={scopeRef}>
      <Button
        view="default"
        pin="circle-circle"
        size="l"
        icon={(className) => <Icon className={className} glyph="addDocument" />}
        onClick={() => setVisible(!isVisible)}
      >
        Добавить документы
      </Button>
      <DrawerPhone
        {...args}
        view="default"
        visible={isVisible}
        scope={scopeRef}
        onClose={() => setVisible(false)}
      >
        <List
          header={<div className="MainList">Добавить документ</div>}
          groups={[
            <ListGroups
              key={0}
              header={<div className="Group1">Удостоверения личности</div>}
              items={renderDrawerItem()}
            />,
            <ListGroups
              key={1}
              header={<div className="Group2">Госуслуги</div>}
              items={[...renderDrawerItem(), ...renderDrawerItem(), ...renderDrawerItem()]}
            />,
          ]}
        />
      </DrawerPhone>
    </div>
  );
};

export const Default = Template.bind({});

Default.args = {};
