import React from 'react';

import { cn } from '@bem-react/classname';

import { createSlot, useSlots } from '../../libs/slots';
import { PageHeaderLogo } from '../Logo';

import './Header.css';

const b = cn('PageHeader');

interface IPageHeaderProps {
  passportHost?: string;
  isProfile?: boolean;
  lang: string;
  tld: string;
  linkComponent?: React.ReactType;
  plus?: React.ReactNode;
  user?: React.ReactNode;
}

const SuggestSlot = createSlot('Suggest');

const _PageHeader: React.FC<IPageHeaderProps> = (props) => {
  const { isProfile, lang, tld, linkComponent, plus, user, passportHost } = props;
  const slots = useSlots(props);

  const suggest = slots.get(SuggestSlot);

  return (
    <header className={b()}>
      <div className={b('left')}>
        <PageHeaderLogo
          passportHost={passportHost}
          tld={tld}
          lang={lang}
          isProfile={isProfile}
          linkComponent={linkComponent}
        />
      </div>
      {suggest && <div className={b('Center')}>{suggest.rendered}</div>}
      <div className={b('right')}>
        {plus && <div className={b('plus')}>{plus}</div>}
        {user && <div className={b('user')}>{user}</div>}
      </div>
    </header>
  );
};

export const PageHeader = Object.assign(_PageHeader, {
  Suggest: SuggestSlot,
});
