import React, { Suspense, VFC, lazy } from 'react';

import type { HeaderSuggestProps } from './HeaderSuggest';

const LazyHeaderSuggest = lazy(() => import('./HeaderSuggest'));

export const HeaderSuggest: VFC<HeaderSuggestProps> = (props) => {
  return (
    <Suspense fallback={null}>
      <LazyHeaderSuggest {...props} />
    </Suspense>
  );
};
