import React, { VFC } from 'react';

import { Provider, SearchSuggest, createApi, useSuggestList } from '@yandex-id/search-suggest';

export interface HeaderSuggestProps {
  scale?: 'medium' | 'large';
  layout?: 'static' | 'fullscreen';
}

const api = createApi({
  searchUrl: '/order-history/api/search',
  suggestUrl: '/order-history/api/suggest',
});

export const HeaderSuggest: VFC<HeaderSuggestProps> = (props) => {
  const { scale, layout } = props;
  const list = useSuggestList(api);

  return (
    <Provider>
      <SearchSuggest list={list} layout={layout} scale={scale} />
    </Provider>
  );
};

export default HeaderSuggest;
