hermione.skip.in(/./);
describe('Hint', function () {
  const elements = {
    component: '.Hint',
  };

  describe('Default', function () {
    it('base', async function () {
      const { browser } = this;

      await browser.yaOpenStory('hint', 'default');
      await browser.assertView('default', elements.component);
    });

    it('with link', async function () {
      const { browser } = this;

      await browser.yaOpenStory('hint', 'default', { args: 'text:Some text;link:Some link' });
      await browser.assertView('default-link', elements.component);
    });

    it('with link and hover', async function () {
      const { browser } = this;

      await browser.yaOpenStory('hint', 'default', { args: 'text:Some text;link:Some link' });
      const hint = await browser.$(elements.component);

      await hint.moveTo();
      await browser.assertView('default-link-hover', elements.component);
    });

    it('focused', async function () {
      const { browser } = this;

      await browser.yaOpenStory('hint', 'default');
      const hint = await browser.$(elements.component);

      await hint.click();
      await hint.moveTo({ xOffset: -10, yOffset: -10 });
      await browser.assertView('default-focused', elements.component);
    });
  });

  describe('Not clickable', function () {
    it('with link and hover', async function () {
      const { browser } = this;

      await browser.yaOpenStory('hint', 'not-clickable', {
        args: 'text:Some text;link:Some link',
      });
      const hint = await browser.$(elements.component);

      await hint.moveTo();
      await browser.assertView('not-clickable-link-hover', elements.component);
    });

    it('focused', async function () {
      const { browser } = this;

      await browser.yaOpenStory('hint', 'not-clickable');
      const hint = await browser.$(elements.component);

      await hint.click();
      await hint.moveTo({ xOffset: -10, yOffset: -10 });
      await browser.assertView('not-clickable-focused', elements.component);
    });
  });

  describe('vanilla-link', () => {
    it('Default', async function () {
      const { browser } = this;

      await browser.yaOpenStory('hint', 'vanilla-link');
      await browser.assertView('default', elements.component);
    });
  });
});
