import React from 'react';

import { Story } from '@storybook/react';

import { Icon } from '../../Icon';
import { Hint, HintProps } from '../Hint';

type DefaultArgs = Pick<HintProps, 'text' | 'link' | 'onPress' | 'variant'>;

export const Default: Story<DefaultArgs> = (args) => {
  const beforeRenderPropFn = (hovered: boolean) => (
    <Icon type="passport" style={{ opacity: hovered ? 0.5 : 1 }} />
  );

  const afterRenderPropFn = (hovered: boolean) => (
    <span style={{ opacity: hovered ? 0.5 : 1 }}>42</span>
  );

  return <Hint {...args} before={beforeRenderPropFn} after={afterRenderPropFn} />;
};

Default.args = {
  text: 'Добавьте телефон, чтобы усилить защиту аккаунта',
};

Default.argTypes = {
  text: {
    type: { name: 'string', required: true },
  },
  link: {
    type: { name: 'string', required: false },
  },
  onPress: { action: 'pressed' },
  variant: {
    control: { type: 'select' },
    options: ['neutral', 'positive', 'negative'],
  },
};
