import React, { AnchorHTMLAttributes, FC } from 'react';

import { Story } from '@storybook/react';

import { Icon } from '../../Icon';
import { Hint, HintProps } from '../Hint';

type ComponentLinkArgs = Pick<HintProps, 'to' | 'title' | 'target' | 'rel'>;

const Link: FC<
  Omit<AnchorHTMLAttributes<HTMLAnchorElement>, 'href'> & {
    to: string;
  }
> = (props) => {
  const { to, ...restProps } = props;

  return (
    <a {...restProps} href={to}>
      {props.children}
    </a>
  );
};

export const ComponentLink: Story<ComponentLinkArgs> = (args) => {
  const beforeRenderPropFn = (hovered: boolean) => (
    <Icon type="passport" style={{ opacity: hovered ? 0.5 : 1 }} />
  );

  return <Hint {...args} before={beforeRenderPropFn} text="Тестовая ссылка" as={Link} />;
};

ComponentLink.args = {
  to: 'https://yandex.ru',
  target: '',
  rel: '',
  title: 'click me!',
};
