import React from 'react';

import { Story } from '@storybook/react';

import { Icon } from '../../Icon';
import { Hint, HintProps } from '../Hint';

type NotClickableArgs = Pick<HintProps, 'text' | 'link'>;

export const NotClickable: Story<NotClickableArgs> = (args) => {
  const beforeRenderPropFn = (hovered: boolean) => (
    <Icon type="passport" style={{ opacity: hovered ? 0.5 : 1 }} />
  );

  return <Hint {...args} before={beforeRenderPropFn} />;
};

NotClickable.args = {
  text: 'Добавьте телефон, чтобы усилить защиту аккаунта',
};

NotClickable.argTypes = {
  text: {
    type: { name: 'string', required: true },
  },
  link: {
    type: { name: 'string', required: false },
  },
};
