import React from 'react';

import { Story } from '@storybook/react';

import { Icon } from '../../Icon';
import { Hint, HintProps } from '../Hint';

type VanillaLinkArgs = Pick<HintProps, 'href' | 'title' | 'target' | 'rel'>;

export const VanillaLink: Story<VanillaLinkArgs> = (args) => {
  const beforeRenderPropFn = (hovered: boolean) => (
    <Icon type="passport" style={{ opacity: hovered ? 0.5 : 1 }} />
  );

  return <Hint {...args} before={beforeRenderPropFn} text="Тестовая ссылка" />;
};

VanillaLink.args = {
  href: 'https://yandex.ru',
  target: '',
  rel: '',
  title: 'click me!',
};
