import { cn } from '@bem-react/classname';
import { compose, composeU } from '@bem-react/core';
import {
  Icon as IconBase,
  withGlyphCaretsV,
  withGlyphTypeCheck,
  withGlyphTypeClose,
  withGlyphTypeCrossWebsearch,
  withGlyphTypeTick,
  withTypeArrow,
} from '@yandex-lego/components/Icon/';

import { withGlyphAddDocument } from './_glyph/Icon_glyph_addDocument';
import { withGlyphFind } from './_glyph/Icon_glyph_find';
import { withGlyphPlus } from './_glyph/Icon_glyph_plus';
import { withTypeaddDocument } from './_type/Icon_type_addDocument';
import { withTypearrowRight } from './_type/Icon_type_arrowRight';
import {
  withTypeDriverLicense,
  withTypeDriverLicenseInactive,
} from './_type/Icon_type_driverLicense';
import { withTypeEmptyDocument } from './_type/Icon_type_emptyDocument';
import { withTypefillDocument } from './_type/Icon_type_fillDocument';
import { withTypeInn, withTypeInnInactive } from './_type/Icon_type_inn';
import { withTypeIntPassport, withTypeIntPassportInactive } from './_type/Icon_type_intPassport';
import { withTypeOms, withTypeOmsInactive } from './_type/Icon_type_oms';
import { withTypePassport, withTypePassportInactive } from './_type/Icon_type_passport';
import { withTypePlus } from './_type/Icon_type_plus';
import { withTypeSnils, withTypeSnilsInactive } from './_type/Icon_type_snils';

import './Icon.css';

export const cnIcon = cn('Icon');

export const Icon = compose(
  composeU(
    withTypeArrow,
    withTypePlus,
    withTypeEmptyDocument,
    withTypearrowRight,
    withTypeaddDocument,
    withTypefillDocument,
    withTypeInn,
    withTypeIntPassport,
    withTypeOms,
    withTypePassport,
    withTypeSnils,
    withTypeDriverLicense,
    withTypePassportInactive,
    withTypeSnilsInactive,
    withTypeOmsInactive,
    withTypeIntPassportInactive,
    withTypeInnInactive,
    withTypeDriverLicenseInactive,
  ),
  composeU(
    withGlyphCaretsV,
    withGlyphTypeClose,
    withGlyphTypeCheck,
    withGlyphTypeTick,
    withGlyphAddDocument,
    withGlyphFind,
    withGlyphPlus,
    withGlyphTypeCrossWebsearch,
  ),
)(IconBase);
