/* eslint-disable react/no-unknown-property */
import React from 'react';

import { withBemMod } from '@bem-react/core';
import { IIconProps, cnIcon } from '@yandex-lego/components/Icon/desktop';

export interface IWithGlyphAddDocumentProps {
  /**
   * Символ иконки
   */
  glyph?: 'addDocument';
}

/**
 * Модификатор, отвечающий за символ иконки.
 * @param {IIconGlyphProps} props
 */
export const withGlyphAddDocument = withBemMod<IWithGlyphAddDocumentProps, IIconProps>(
  cnIcon(),
  { glyph: 'addDocument' },
  (Icon) =>
    ({ className, ...props }) =>
      (
        <Icon {...props} className={cnIcon({ hasGlyph: true }, [className])}>
          <svg width="22" height="22" fill="none" xmlns="http://www.w3.org/2000/svg">
            {/* eslint-disable-next-line max-len */}
            <path
              d="M3.205 0H6.99c.775 0 1.043.028 1.34.096.297.069.56.178.818.34.258.161.468.33 1.015.878l2.522 2.522c.547.547.717.757.879 1.015.161.258.27.521.338.818.029.122.05.24.065.39A8.958 8.958 0 0 0 9.343 8h-.138c-1.115 0-1.519-.116-1.926-.334a2.272 2.272 0 0 1-.945-.945C6.116 6.314 6 5.91 6 4.795V2H3.205c-.427 0-.694.019-.849.049a.353.353 0 0 0-.134.049.275.275 0 0 0-.124.124.353.353 0 0 0-.049.134c-.03.155-.049.422-.049.849v13.59c0 .427.019.694.049.849.012.06.017.074.049.134a.275.275 0 0 0 .124.125c.06.031.073.036.134.048.155.03.422.049.849.049h3.307c.252.712.59 1.383 1.004 2H3.205c-1.115 0-1.519-.116-1.926-.334a2.272 2.272 0 0 1-.945-.945C.116 18.314 0 17.91 0 16.795V3.205C0 2.09.116 1.686.334 1.279.552.872.872.552 1.279.334 1.686.116 2.09 0 3.205 0ZM8 2.083v2.712c0 .427.019.694.049.849.012.06.017.074.049.134a.275.275 0 0 0 .124.124c.06.032.073.037.134.049.155.03.422.049.849.049h2.711a.676.676 0 0 0-.047-.088c-.079-.126-.18-.245-.598-.662l-2.52-2.521c-.418-.417-.537-.52-.663-.598A.685.685 0 0 0 8 2.083ZM15 10a5 5 0 1 0 0 10 5 5 0 0 0 0-10Zm-7 5a7 7 0 1 1 14 0 7 7 0 0 1-14 0Zm7-3.5a1 1 0 0 0-1 1V14h-1.5a1 1 0 1 0 0 2H14v1.5a1 1 0 1 0 2 0V16h1.5a1 1 0 1 0 0-2H16v-1.5a1 1 0 0 0-1-1Z"
              fill="#262633"
            />
          </svg>
        </Icon>
      ),
);
