/* eslint-disable react/no-unknown-property */
import React from 'react';

import { withBemMod } from '@bem-react/core';
import { IIconProps, cnIcon } from '@yandex-lego/components/Icon/desktop';

export interface IWithGlyphFindProps {
  /**
   * Символ иконки
   */
  glyph?: 'find';
}

/**
 * Модификатор, отвечающий за символ иконки.
 * @param {IIconGlyphProps} props
 */
export const withGlyphFind = withBemMod<IWithGlyphFindProps, IIconProps>(
  cnIcon(),
  { glyph: 'find' },
  (Icon) =>
    ({ className, ...props }) =>
      (
        <Icon {...props} className={cnIcon({ hasGlyph: true }, [className])}>
          <svg width="19" height="19" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M7.5 14.999c1.71 0 3.287-.573 4.55-1.537l4.743 4.744a1 1 0 1 0 1.414-1.414l-4.744-4.744a7.5 7.5 0 1 0-5.963 2.95Zm5.5-7.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0Z"
              fill="#262633"
            />
          </svg>
        </Icon>
      ),
);
