/* eslint-disable react/no-unknown-property */
import React from 'react';

import { withBemMod } from '@bem-react/core';
import { IIconProps, cnIcon } from '@yandex-lego/components/Icon/desktop';

export interface IWithGlyphPlusProps {
  /**
   * Символ иконки
   */
  glyph?: 'plus';
}

/**
 * Модификатор, отвечающий за символ иконки.
 * @param {IIconGlyphProps} props
 */
export const withGlyphPlus = withBemMod<IWithGlyphPlusProps, IIconProps>(
  cnIcon(),
  { glyph: 'plus' },
  (Icon) =>
    ({ className, ...props }) =>
      (
        <Icon {...props} className={cnIcon({ hasGlyph: true }, [className])}>
          <svg width="24" height="24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M12 3a1 1 0 0 0-1 1v7H4a1 1 0 1 0 0 2h7v7a1 1 0 1 0 2 0v-7h7a1 1 0 1 0 0-2h-7V4a1 1 0 0 0-1-1Z"
              fill="#9397AD"
            />
          </svg>
        </Icon>
      ),
);
